{ P_58_2 -         }
(*   ABCNet *)

function Assigned(p : pointer): boolean;  {  ABCNet }
begin
  Assigned:= p<>nil
end;


type
      PNode = ^TNode;     {    - }
      PLink = ^TLink;     {      }

      TLink = record      {    }
        mLink : PNode;    {     }
        mNext : PLink;    {       }
      end;

      TColor = (White, Gray, Black);  {      }

      TNode = record      {      ( ) }
        mName : Char;     {   ( ) }
        mColor: TColor;   {  ,   }
        mDist : integer;  {    ,  -1 }
        mPrev : PNode;    { ,      }
        mLinks: PLink;    {    (   ) }
        mNext : PNode;    {       }
      end;

var List : PNode;   {     }
    Que  : PLink;   {    }

  {    ( )    }

function GetPtr(aName : char): PNode;
var p : PNode;
begin
  p:= List; {      }
  {     }
  while Assigned(p) do begin
    if p^.mName= aName
      then break             { ! }
      else p:= p^.mNext;     {    }
  end;
  GetPtr:= p;
end;

  {     (),
        List
          }

function MakeNode(aName : Char): PNode;
var  p : PNode;
begin
  New(p);             {   }
  p^.mName:= aName;   {   }
  p^.mLinks:=nil;     {     }
  p^.mNext:= List;    {       }
  List:= p;           {      }
  MakeNode:= p;       {    }
end;

  {     p1   p2 }

procedure Link(p1, p2 : PNode);
var  p : PLink;
begin
  New(p);                 {  - }
  p^.mLink:= p2;          {  mLink    p2 }
  p^.mNext:= p1^.mLinks;  {       }
  p1^.mLinks:= p;         {      }
end;

  {      .
          ( )
      - (   ) }

procedure ReadData(var F: Text);
var C : Char;
    p, q : PNode;
begin
  Reset(F);
  while not Eof(F) do begin
    if not Eoln(F) then begin     {     }
      Read(F, C);                 {    }
      C:=UpCase(C);               {     }
      p:= GetPtr(C);              {      ? }
      if not Assigned(p)
        then p:= MakeNode(C);     {  , -  }
      while not Eoln(F) do begin  {  -    }
        Read(F, C);
        C:= UpCase(C);
        if C in ['A'..'Z'] then begin   {    ... }
          q:= GetPtr(C);                {    }
          if not Assigned(q)
            then q:= MakeNode(C);       {   , -  }
          Link(p, q);                   {   p  q }
        end
      end
    end;
    Readln(F);   {      }
  end;
end;

  {         Que }

procedure PutInQue(arg: PNode);
var p: PLink;
begin
  New(p);             {   - }
  p^.mLink:= arg;     {     }
  {      }
  p^.mNext:= Que;     {     }
  Que:=p;             {      }
end;

  {       }

function GetFromQue(var arg: Pnode): boolean;
var p, q: PLink;
begin
  GetFromQue:= Assigned(Que);
  if Assigned(Que) then begin
    {    ()  }
    p:= Que;  q:=p;
    {      ,     ! }
    while Assigned(p^.mNext) do begin
      q:=p;          {  }
      p:=p^.mNext;   {  }
    end;
    {  p    ,
      q -   (  - ,     ) }
    arg:= p^.mLink;
    if p=q                     {      ... }
      then Que:= nil           {    }
      else q^.mNext:= nil;     {   ""   }
    Dispose(p);                {     }
  end;
end;

  {     " " }

procedure InitList;
var p : PNode;
begin
  p:= List; {      }
  {      }
  while Assigned(p) do begin
    p^.mColor:= White;  {     }
    p^.mDist := -1;     {      -1 }
    p^.mPrev := nil;    { ,      }
    p:= p^.mNext;       {   }
  end;
end;

  {   () "",     arg }

procedure Expand(arg : PNode);
var p : PNode;
    q : PLink;
begin
  arg^.mDist:= 0;           {     = 0 }
  arg^.mColor:= Gray;       {    }
  PutInQue(arg);            {      }
  while GetFromQue(p) do begin    {     P }
    q:= p^.mLinks;                {    }
    while Assigned(q) do begin
      if q^.mLink^.mColor = White then begin  {     }
        q^.mLink^.mColor:= Gray;              {    }
        q^.mLink^.mDist:= p^.mDist +1;        {    }
        q^.mLink^.mPrev:= p;                  {   }
        PutInQue(q^.mLink);                   {      }
      end;
      q:= q^.mNext;    {     }
    end;
    p^.mColor:= Black; {       }
  end;
end;

function MakePath(arg : PNode): string;
var p : PNode;
    S : string;
begin
  S:= arg^.mName;
  p:= arg^.mPrev;
  while Assigned(p) do begin
    S:= p^.mName +' -> '+ S;
    p:= p^.mPrev;
  end;
  MakePath:= S;
end;

var    F_In {, F_Out} : Text; {     }
       C1, C2 : Char;         {   ""  "" }
       Start, Stop : PNode;   {   ""  "" }

begin   {   }

  {       }
  List:= nil;  Que:= nil;
  Assign(F_In, 'P_57_1.in');
  ReadData(F_In);             {   }
  {     }
  repeat
    Write('= '); Readln(C1);
    C1:= UpCase(C1);
    if not (C1 in ['A'..'Z']) then break;
    Write('  = '); Readln(C2);
    C2:= UpCase(C2);
    if not (C2 in ['A'..'Z']) then break;
    Start:= GetPtr(C1);       {   }
    Stop:= GetPtr(C2);        {   }
    if Assigned(Start) and Assigned(Stop) then begin
     {     }
      InitList;          {       }
      Expand(Start);     {  ""   Start }
      Writeln (Stop^.mDist:3, '':3, MakePath(Stop));
    end;
  until false
end.


